/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures.InDevelopment.Trees;

import Data_Structures.ADTs.BST;
import Data_Structures.ADTs.Heap;
import Data_Structures.ADTs.MeldableHeap;
import Data_Structures.ADTs.Pairable;
import Data_Structures.ADTs.PriorityQueue;
import Data_Structures.Structures.Box;
import Data_Structures.Structures.Data_Structure;
import Data_Structures.Structures.UBA;
import java.util.Random;
import util.testing;

public class Treap<E extends Comparable<E>>
extends BST<E, Treap<E>>
implements MeldableHeap<E, Treap<E>>,
Heap<E>,
PriorityQueue<E, Treap<E>> {
    static Random R = new Random();
    Node root;
    Node EMPTY_NODE;

    public Treap() {
        this.root = this.EMPTY_NODE = new Node(this);
        this.size = 0;
    }

    public Treap(E ... data) {
        this.EMPTY_NODE = new Node(this);
        throw new Error("Implement Me Please!");
    }

    private Treap(Node n) {
        this.EMPTY_NODE = new Node(this);
        this.root = n;
    }

    @Override
    public int size() {
        return this.root.size;
    }

    @Override
    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public Treap<E> add_static(E elem) {
        int priority = this.generatePriority();
        return this.add_static(elem, priority);
    }

    @Override
    public Treap<E> add_static(E elem, int priority) {
        Node result = this.root.add(elem, priority = this.restrictRange(priority));
        return result == null ? this : new Treap<E>(result);
    }

    public Treap<E> static_append(E ... data) {
        Treap other = new Treap(data);
        return this.meld(other);
    }

    @Override
    public boolean remove(E elem) {
        throw new Error("Try \"static_remove\" instead");
    }

    public Treap<E> remove_static(E elem) {
        Node temp = this.root.remove(elem);
        if (temp != null) {
            return new Treap<E>(temp);
        }
        return this;
    }

    @Override
    public boolean isLeaf() {
        return this.root.isLeaf();
    }

    @Override
    public E getRoot() {
        if (this.root.isEmpty()) {
            throw new Error("Error : Tree is empty");
        }
        return this.root.data;
    }

    @Override
    public boolean contains(E elem) {
        return this.root.contains(elem);
    }

    @Override
    protected boolean hasLeftChild() {
        return this.root.left != null;
    }

    @Override
    protected boolean hasRightChild() {
        return this.root.right != null;
    }

    protected Treap<E> getLeftChild() {
        if (this.root.isEmpty()) {
            throw new Error("Error: Empty trees have no left child.");
        }
        return new Treap<E>(this.root.left);
    }

    protected Treap<E> getRightChild() {
        if (this.root.isEmpty()) {
            throw new Error("Error: Empty trees have no right child.");
        }
        return new Treap<E>(this.root.right);
    }

    @Override
    public Data_Structure<E> clone() {
        return this;
    }

    private int generatePriority() {
        int val = R.nextInt();
        return this.restrictRange(val);
    }

    private int restrictRange(int val) {
        switch (val) {
            case -2147483648: {
                return -2147483647;
            }
            case 0x7FFFFFFF: {
                return 0x7FFFFFFE;
            }
        }
        return val;
    }

    private Treap<E> updatePriority(E elem, int priority) {
        BST output = this.remove_static((Comparable)elem);
        return ((Treap)output).add_static(elem, priority);
    }

    public Pairable<Treap<E>> split(E mid) {
        Treap<E> output = this.updatePriority(mid, Integer.MAX_VALUE);
        UBA<Treap<Treap>> treaps = new UBA<Treap<Treap>>(2);
        treaps.append(new Treap<E>(output.root.left), new Treap<E>(output.root.right));
        return treaps;
    }

    @Override
    public Treap<E> meld(Treap<E> other) {
        boolean big = this.size() > other.size();
        BST bigger = big ? this : other;
        Treap<E> smaller = !big ? this : other;
        for (Comparable elem : smaller) {
            bigger = bigger.add_static(elem);
        }
        return bigger;
    }

    public Treap<E> unsplit(Treap<E> left, E mid, Treap<E> right) {
        Node output = new Node(this, (Comparable)mid, Integer.MAX_VALUE, left.root, right.root);
        return new Treap<E>(output).remove_static((Comparable)mid);
    }

    public Treap<E> unsplit_and_insert(Treap<E> left, E mid, Treap<E> right, int priority) {
        Node output = new Node(this, (Comparable)mid, Integer.MAX_VALUE, left.root, right.root);
        return super.updatePriority(mid, priority);
    }

    public Treap<E> unsplit_and_insert(Treap<E> left, E mid, Treap<E> right) {
        Node output = new Node(this, (Comparable)mid, Integer.MAX_VALUE, left.root, right.root);
        return super.updatePriority(mid, this.generatePriority());
    }

    public Treap<E> range(E left_bound, E right_bound) {
        return this.split(right_bound).getFirst().split(left_bound).getLast();
    }

    public Treap<E> left_range(E right_bound) {
        return this.split(right_bound).getFirst();
    }

    @Override
    public String toString() {
        return this.root.toString();
    }

    @Override
    public Treap<E> deleteMin(Box<E> output) {
        output.val = this.peekMin();
        return this.deleteMin();
    }

    @Override
    public E peekMin() {
        throw new Error("Not Yet Implemented");
    }

    @Override
    public Treap<E> deleteMin() {
        throw new Error("Not Yet Implemented");
    }

    @Override
    public void add(E elem, int priority) {
        throw new Error("Treaps are immutable, so please use add_static() instead.");
    }

    @Override
    public void add(E elem) {
        throw new Error("Treaps are immutable, so please use add_static() instead.");
    }

    @Override
    public void append(E ... elem) {
        throw new Error("Treaps are immutable, please use append_static() instead");
    }

    public boolean isTreap() {
        return this.root.isTreap();
    }

    @Override
    public Treap<E> insert(E item) {
        return this.add_static((Comparable)item);
    }

    @Override
    public E delMin() {
        throw new Error("Not Yet Implemented");
    }

    private class Node {
        final Node left;
        final Node right;
        final E data;
        final int priority;
        final int size;
        boolean isTreap;
        final /* synthetic */ Treap this$0;

        public Node(Treap treap) {
            this.this$0 = treap;
            this.isTreap = false;
            this.left = null;
            this.right = null;
            this.data = null;
            this.size = 0;
            this.priority = 0;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        private Node(E elem, int prior) {
            this.this$0 = (Treap)n;
            this.isTreap = false;
            this.data = elem;
            this.left = n.EMPTY_NODE;
            this.right = n.EMPTY_NODE;
            this.priority = prior;
            this.size = 1;
        }

        private Node(E elem, int prior, Node left_in, Node right_in) {
            this.this$0 = var1_1;
            this.isTreap = false;
            this.data = elem;
            this.left = left_in;
            this.right = right_in;
            this.priority = prior;
            this.size = this.left.size + 1 + this.right.size;
        }

        public Node clone() {
            return this;
        }

        public boolean isEmpty() {
            return this.data == null;
        }

        public boolean isLeaf() {
            return !this.isEmpty() && this.left.isEmpty() && this.right.isEmpty();
        }

        public Node add(E elem, int priority_new) {
            if (this.isEmpty()) {
                return new Node(this.this$0, elem, priority_new);
            }
            int compare = elem.compareTo(this.data);
            if (compare == 0) {
                return null;
            }
            if (compare < 0) {
                Node left_new = this.left.add(elem, priority_new);
                if (left_new == null) {
                    return null;
                }
                if (left_new.isEmpty() || left_new.priority <= this.priority) {
                    Node output = new Node(this.this$0, this.data, this.priority, left_new, this.right);
                    return output;
                }
                Node output_right = new Node(this.this$0, this.data, this.priority, left_new.right, this.right);
                Node output = new Node(this.this$0, left_new.data, left_new.priority, left_new.left, output_right);
                return output;
            }
            Node right_new = this.right.add(elem, priority_new);
            if (right_new == null) {
                return null;
            }
            if (right_new.isEmpty() || right_new.priority <= this.priority) {
                Node output = new Node(this.this$0, this.data, this.priority, this.left, right_new);
                return output;
            }
            Node output_left = new Node(this.this$0, this.data, this.priority, this.left, right_new.left);
            Node output = new Node(this.this$0, right_new.data, right_new.priority, output_left, right_new.right);
            return output;
        }

        public Node remove(E elem) {
            if (this.isEmpty()) {
                return null;
            }
            if (this.data.equals(elem)) {
                if (this.isLeaf()) {
                    return this.this$0.EMPTY_NODE;
                }
                if (this.left.isEmpty()) {
                    return this.right;
                }
                if (this.right.isEmpty()) {
                    return this.left;
                }
                if (this.left.priority > this.right.priority) {
                    Node output_right = new Node(this.this$0, this.data, this.priority, this.left.right, this.right);
                    output_right = output_right.remove(elem);
                    Node output = new Node(this.this$0, this.left.data, this.left.priority, this.left.left, output_right);
                    return output;
                }
                Node output_left = new Node(this.this$0, this.data, this.priority, this.left, this.right.left);
                output_left = output_left.remove(elem);
                Node output = new Node(this.this$0, this.right.data, this.right.priority, output_left, this.right.right);
                return output;
            }
            int compare = elem.compareTo(this.data);
            Node output = null;
            if (compare < 0) {
                Node left_new = this.left.remove(elem);
                if (left_new != null) {
                    output = new Node(this.this$0, this.data, this.priority, left_new, this.right);
                }
            } else {
                Node right_new = this.right.remove(elem);
                if (right_new != null) {
                    output = new Node(this.this$0, this.data, this.priority, this.left, right_new);
                }
            }
            return output;
        }

        public boolean contains(E elem) {
            Node child;
            if (this.isEmpty()) {
                return false;
            }
            if (this.data.equals(elem)) {
                return true;
            }
            Node node = child = elem.compareTo(this.data) < 0 ? this.left : this.right;
            if (child == null) {
                return false;
            }
            return child.contains(elem);
        }

        public String toString() {
            if (this.isEmpty()) {
                return "EMPTY";
            }
            return "Node(" + this.left + ", " + this.data + ", Size = " + this.size + ", priority = " + this.priority + ", " + this.right + ")";
        }

        public boolean isTreap() {
            if (this.isLeaf() || this.isEmpty()) {
                return true;
            }
            if (this.isTreap) {
                return true;
            }
            testing.ASSERT(this.left.isTreap());
            testing.ASSERT(this.right.isTreap());
            testing.ASSERT(this.left.data == null || this.data.compareTo(this.left.data) >= 0);
            testing.ASSERT(this.right.data == null || this.data.compareTo(this.right.data) <= 0);
            testing.ASSERT(this.left.isEmpty() || this.priority >= this.left.priority);
            testing.ASSERT(this.right.isEmpty() || this.priority >= this.right.priority);
            testing.ASSERT(this.size == this.left.size + 1 + this.right.size);
            this.isTreap = !(!this.left.isTreap() || !this.right.isTreap() || !this.left.isEmpty() && this.data.compareTo(this.left.data) < 0 || !this.right.isEmpty() && this.data.compareTo(this.right.data) >= 0 || !this.left.isEmpty() && this.priority < this.left.priority || !this.right.isEmpty() && this.priority < this.right.priority || this.size != this.left.size + 1 + this.right.size);
            return this.isTreap;
        }
    }
}

